<?php defined('PF_VERSION') OR exit('Access denied');?>
<?php
add_toolbar_button(form_button("<i class='glyphicon glyphicon-plus'></i> " . __('New announcement', 'announcement'), array('onclick' => "window.location = '" . $_SERVER["REQUEST_URI"] . "&action=create'", 'class' => 'btn btn-primary')));
if(!empty($_SESSION['success'])){
    $note   =   $_SESSION['success'];
    unset($_SESSION['success']);
}
if (!empty($note)) {
    ?>
    <script>notif('<?php echo $note; ?>');</script>
<?php } ?>
<div class="panel panel-default">
    <div class="panel-heading">
        <h3 class="panel-title"><i class="fa fa-list"></i> <?php echo __('Announcement', 'announcement'); ?></h3>
    </div>
    <div class="panel-body">
        <div class="row margin-bottom-20">
            <div class="col-md-8">
                <div class="btn-group pull-left btnGroupBulkAction" id="action-box">
                    <button type="button" class="btn btn-default btn-md btn-flat dropdown-toggle" data-toggle="dropdown">
                        <?php echo __('Select Action', 'announcement'); ?> <span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu" role="menu" id="bulkAction">
                        <li><a href="#" onclick="confirmaction('del')"><?php echo __('Delete', 'announcement'); ?></a></li>
                        <li><a href="#" onclick="confirmaction('publish')"><?php echo __('Publish', 'announcement'); ?></a></li>
                        <li><a href="#" onclick="confirmaction('unpublish')"><?php echo __('Unpublish', 'announcement'); ?></a></li>
                    </ul>
                </div>
            </div>
            <div class="col-md-4 search-form">
                <form name="search" method="get" action="" class="form-inline">
                    <div class="input-group">
                        <input type="hidden" name="admin-page" value="announcement" />
                        <input type="text" class="form-control" name="announcement_name" placeholder='<?php echo __('Please enter the search conditions','announcement'); ?>' value='<?php if (!empty($_GET['announcement_name'])) {
                            echo $_GET['announcement_name'];
                        } ?>'>
                        <span class="input-group-btn">
                            <button class="btn btn-default btn-flat" type="submit" id="btnSearch">
                                <i class="fa fa-search"></i> <?php echo __('Search', 'announcement') ?>
                            </button>
                            <a href="<?php echo admin_url(array('admin-page' => 'announcement'), false); ?>" class="btn btn-default btn-flat"> 
                                <i class="fa fa-times-circle"></i>
                            </a>
                        </span>
                    </div>
                </form>
            </div>
        </div>
        <div class="row medium-action padding-10-0">
            <div class="col-md-6"> 
                <div class="btn-group">
                    <button type="button" class="btn btn-default btn-sm btn-flat dropdown-toggle" data-toggle="dropdown">
                        <?php
                        if (empty($_GET['publish'])) {
                            echo __('All', 'announcement');
                        } elseif ($_GET['publish'] == 1) {
                            echo __('Published', 'announcement');
                        } elseif ($_GET['publish'] == 2) {
                            echo __('Unpublished', 'announcement');
                        }
                        ?>
                        <span class="caret"></span>
                    </button>
                    <ul class="dropdown-menu" role="menu">
                        <li><a href="?admin-page=announcement"><?php echo __('All', 'announcement'); ?></a></li>
                        <li><a href="?admin-page=announcement&publish=1"><?php echo __('Published', 'announcement'); ?></a></li>
                        <li><a href="?admin-page=announcement&publish=2"><?php echo __('Unpublished', 'announcement'); ?></a></li>
                    </ul>
                </div>
            </div>
            <div class="col-md-6">
                <div class="pull-right">
                    	<?php echo $pages->short_page_link(); ?>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <form method=post action='' id='checkform'>
                    <input type="hidden" id='action' name="action" />
                    <div class="table-responsive">
                        <table class='bootstrap-table' id='listcheck'>
                    <thead>
                        <tr>
                            <th data-fixed="left" class='th'><label><input type='checkbox' id='checkall' name='checkall' /> </label></th>
                            <th class='width400'><?php echo __("Content", "announcement"); ?></th>
                            <th class='width200'><?php echo __("Publish date", "announcement"); ?></th>
                            <th class='width200'><?php echo __("Unpublish date", "announcement"); ?></th>
                            <th class='width150'><?php echo __("Status", "announcement"); ?></th>
                            <th data-fixed="right" class='width150'><?php echo __("Actions", "announcement"); ?></th>
                        </tr>
                    </thead>
                    <tbody>
<?php foreach ($list as $row) { ?>
                            <tr><td> <input type='checkbox' name='cid[]' value=' <?php echo $row['id']; ?> ' class='checkbox' /></td>
                                <td><?php if(strlen($row['announcement_content'])>50) echo substr(htmlspecialchars($row['announcement_content']),0,50)."..."; else echo htmlspecialchars($row['announcement_content']); ?></td>
                                <td><?php echo isset($row['announcement_pubdate'])?date($dateformat,    strtotime($row['announcement_pubdate'])):''; ?></td>
                                <td><?php echo isset($row['announcement_unpubdate'])?date($dateformat,  strtotime($row['announcement_unpubdate'])):''; ?></td>
                                <td><?php
                                switch ($row['announcement_status']) {
                                        case '1':
                                            echo "<a href='" . admin_url("admin-page=announcement&do=unpublish&id=" . $row['id']) . "' class='label label-success'>" . __("Published", 'announcement') . "</a>";
                                            break;
                                        default:
                                            echo "<a href='" . admin_url("admin-page=announcement&do=publish&id=" . $row['id']) . "' class='label label-danger'>" . __("Unpublished", 'announcement') . "</a>";
                                            break;
                                        }
                                ?></td>
                                <td><a class='btn btn-info btn-xs' href='<?php echo $_SERVER['REQUEST_URI'] . "&action=edit&id=" . $row['id'] ?>'><i class='fa fa-pencil-square-o'></i> <?php echo __("Edit", "announcement") ?></span></a>
                                    <a class='btn btn-danger btn-xs' onclick="delete_announcement('<?php echo admin_url('do=del&id=' . $row['id']); ?>');
                                  return;">
                                        <i class='fa fa-times-circle'></i> <?php echo __('Delete', 'announcement'); ?>   </a> </td></tr>
<?php } ?>
                    </tbody></table>
                    </div>
                </form>
            </div>
        </div>


    </div>
    <div class="panel-footer">
        <div class="row">
            <div class="col-sm-6">
                <?php echo $pages->page_lable(); ?>
            </div>
            <div class="col-sm-6">
                <!-- Pagination -->
                <?php echo $pages->page_links($org_url . '&'); ?>
                <!-- Pagination -->
            </div>
        </div>
    </div>
</div>
<script>
    function delete_announcement(url) {
        $.sModal({
            image: '<?php echo RELATIVE_PATH; ?>/admin/plugins/theme/layouts/images/confirm.png',
            content: '<?php echo __('Are you sure to delete this item?', 'announcement'); ?>',
            animate: 'fadeDown',
            buttons: [
                {
                    text: '<i class="fa fa-times-circle"></i> <?php echo __('Delete', 'announcement'); ?> ',
                    addClass: 'btn-danger',
                    click: function(id, data) {
                        window.location = url;
                        $.sModal('close', id);
                    }
                },
                {
                    text: ' <?php echo __('Cancel', 'announcement'); ?> ',
                    click: function(id, data) {
                        $.sModal('close', id);
                    }
                },
            ]
        });
    }
    function confirmaction(act) {
        $.sModal({
                image: '<?php echo RELATIVE_PATH; ?>/admin/plugins/theme/layouts/images/confirm.png',
                content: '<?php echo __('Are you sure with this action?', 'announcement'); ?>',
                animate: 'fadeDown',
                buttons: [
                    {
                        text: '<i class="fa fa-times-circle"></i> <?php echo __('Confirm', 'announcement'); ?> ',
                        addClass: 'btn-danger',
                        click: function(id, data) {
                           $('#action').val(act);
                           $('#checkform').submit();
                            $.sModal('close', id);
                        }
                    },
                    {
                        text: ' <?php echo __('Cancel', 'announcement'); ?> ',
                        click: function(id, data) {
                            $.sModal('close', id);
                        }
                    },
                ]
            });
    }
</script>
    </div>